/*
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *
 *  Copyright (C) 2020-2024  The DOSBox Staging Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef DOSBOX_CONFIG_H
#define DOSBOX_CONFIG_H

// This file is a template for the Meson build process.
//
// Placeholders surrounded by '@' characters are substituted with concrete
// values at the start of the build process, and a file `config.cpp` is
// written to the build output directory.

// Git hash of the build
#define BUILD_GIT_HASH ""

/* Operating System
 */

// Defined if compiling for OS from BSD family
/* #undef BSD */

// Defined if compiling for Linux (non-Android)
#define LINUX 1

// Defined if compiling for macOS
/* #undef MACOSX */

// Defined if compiling for Windows (any option)
#ifndef WIN32
/* #undef WIN32 */
#endif

/* CPU and FPU emulation
 *
 * These defines are mostly relevant to modules src/cpu/ and src/fpu/
 */

// The type of cpu this target has
#define C_TARGETCPU POWERPC

// Define to 1 if target CPU supports unaligned memory access
#define C_UNALIGNED_MEMORY 1

// Define to 1 if the target platform needs per-page dynamic core write or execute (W^X) tagging
#define C_PER_PAGE_W_OR_X 1

// Define to 1 to use x86/x86_64 dynamic cpu core
// Can not be used together with C_DYNREC
/* #undef C_DYNAMIC_X86 */

// Define to 1 to use recompiling cpu core
// Can not be used together with C_DYNAMIC_X86
#define C_DYNREC 1

// Define to 1 to enable floating point emulation
#define C_FPU 1

// Define to 1 to use  fpu core implemented in x86 assembler
#define C_FPU_X86 0

// TODO Define to 1 to use inlined memory functions in cpu core
#define C_CORE_INLINE 1

/* Emulator features
 *
 * Turn on or off optional emulator features that depend on external libraries.
 * This way it's easier to port or package on a new platform, where these
 * libraries might be missing.
 */

// Define to 1 to enable internal modem emulation (using SDL2_net)
#define C_MODEM 1

// Define to 1 to enable IPX over Internet networking (using SDL2_net)
#define C_IPX 1

// Enable serial port passthrough support
#define C_DIRECTSERIAL 1

// Define to 1 to use opengl display output support
#define C_OPENGL 1

// Define to 1 to enable FluidSynth integration (built-in MIDI synth)
#define C_FLUIDSYNTH 1

// Define to 1 to enable libslirp Ethernet support
#define C_SLIRP 1

// Define to 1 to enable Novell NE 2000 NIC emulation
#define C_NE2000 1

// Define to 1 to enable the Tracy profiling server
#define C_TRACY 0

// Define to 1 to enable internal debugger (using ncurses or pdcurses)
/* #undef C_DEBUG */

// Define to 1 to enable heavy debugging (requires C_DEBUG)
/* #undef C_HEAVY_DEBUG */

// Define to 1 to enable MT-32 emulator
#define C_MT32EMU 1

// Define to 1 to enable mouse mapping support
#define C_MANYMOUSE 1

// ManyMouse optionally supports the X Input 2.0 protocol (regardless of OS). It
// uses the following define to definitively indicate if it should or shouldn't
// use the X Input 2.0 protocol. If this is left undefined, then ManyMouse makes
// an assumption about availability based on OS type.
#define SUPPORT_XINPUT2 1

// Compiler supports Core Audio headers
/* #undef C_COREAUDIO */

// Compiler supports Core MIDI headers
/* #undef C_COREMIDI */

// Compiler supports Core Foundation headers
/* #undef C_COREFOUNDATION */

// Compiler supports Core Services headers
/* #undef C_CORESERVICES */

// Define to 1 to enable ALSA MIDI support
#define C_ALSA 1

/* Compiler features and extensions
 *
 * These are defines for compiler features we can't reliably verify during
 * compilation time.
 */

#define C_HAS_BUILTIN_EXPECT 1

/* Defines for checking availability of standard functions and structs.
 *
 * Sometimes available functions, structs, or struct fields differ slightly
 * between operating systems.
 */

// Define to 1 when zlib-ng support is provided by the system
/* #undef C_SYSTEM_ZLIB_NG */

// Defined if function clock_gettime is available
#define HAVE_CLOCK_GETTIME 1

// Defined if function __builtin_available is available
/* #undef HAVE_BUILTIN_AVAILABLE */

// Defined if function __builtin___clear_cache is available
#define HAVE_BUILTIN_CLEAR_CACHE 1

// Defined if function mprotect is available
#define HAVE_MPROTECT 1

// Defined if function mmap is available
#define HAVE_MMAP 1

// Defined if mmap flag MAPJIT is available
/* #undef HAVE_MAP_JIT */

// Defined if function pthread_jit_write_protect_np is available
/* #undef HAVE_PTHREAD_WRITE_PROTECT_NP */

// Defined if function sys_icache_invalidate is available
/* #undef HAVE_SYS_ICACHE_INVALIDATE */

// Defined if function pthread_setname_np is available
#define HAVE_PTHREAD_SETNAME_NP 1

// Defind if function setpriority is available
#define HAVE_SETPRIORITY 1

// Defind if function strnlen is available
#define HAVE_STRNLEN 1

// field d_type in struct dirent is not defined in POSIX
// Some OSes do not implement it (e.g. Haiku)
#define HAVE_STRUCT_DIRENT_D_TYPE 1



/* Available headers
 *
 * Checks for non-POSIX headers and POSIX headers not supported on Windows.
 */

#define HAVE_LIBGEN_H 1
#define HAVE_NETINET_IN_H 1
#define HAVE_PWD_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STRINGS_H 1
#define HAVE_SYS_SOCKET_H 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_SYS_XATTR_H 1

/* Hardware-related defines
 */

// Define to 1 when host/target processor uses big endian byte ordering
#define WORDS_BIGENDIAN 1

// Non-4K page size (only on selected architectures)
#define PAGESIZE 4096

/* Windows-related defines
 */

// Prevent <windows.h> from clobbering std::min and std::max
/* #undef NOMINMAX */

// Enables mathematical constants (such as M_PI) in Windows math.h header
// https://docs.microsoft.com/en-us/cpp/c-runtime-library/math-constants
/* #undef _USE_MATH_DEFINES */

// Modern MSVC provides POSIX-like routines, so prefer that over built-in
#define HAVE_STRNLEN 1

// Holds the "--datadir" specified during project setup. This can
// be used as a fallback if the user hasn't populated their
// XDG_DATA_HOME or XDG_DATA_DIRS to include the --datadir.
#define CUSTOM_DATADIR "/usr/local/share"

#endif
